import 'package:flutter/material.dart';

class CommonScaffoldBackActionProvider extends InheritedWidget {
  final VoidCallback? backAction;

  const CommonScaffoldBackActionProvider({
    super.key,
    required this.backAction,
    required super.child,
  });

  static CommonScaffoldBackActionProvider? of(BuildContext context) {
    return context
        .dependOnInheritedWidgetOfExactType<CommonScaffoldBackActionProvider>();
  }

  @override
  bool updateShouldNotify(CommonScaffoldBackActionProvider oldWidget) =>
      backAction != oldWidget.backAction;
}

class CommonScaffoldFabExtendedProvider extends InheritedWidget {
  final bool isExtended;

  const CommonScaffoldFabExtendedProvider({
    super.key,
    required this.isExtended,
    required super.child,
  });

  static CommonScaffoldFabExtendedProvider? of(BuildContext context) {
    return context
        .dependOnInheritedWidgetOfExactType<
          CommonScaffoldFabExtendedProvider
        >();
  }

  @override
  bool updateShouldNotify(CommonScaffoldFabExtendedProvider oldWidget) =>
      isExtended != oldWidget.isExtended;
}
